console.log('animations loaded');

function textAnimation() {
    let text = 'Educație financiară personală, pentru toți românii, oriunde.';
    
    let textMap = text.split('').map((word, index) => {
        const style = `animation-delay: ${(0.5 + index / 50) + "s"}`
        if (word == '') {
            return ' ';
        } else {
            return `<span aria-hidden="true" key="${index}" style="${style}">${word}</span>`;
        }
    }).join('');
    let tag = document.getElementById('title');
    tag.innerHTML = textMap;

}


function buttonTextAnimation() {
    let text = '2023';
    let textMap = text.split('').map((word, index) => {
        const style = `animation-delay: ${(0.5 + index / 15) + "s"}`
        if (word == '') {
            return ' ';
        } else {
            return `<span aria-hidden="true" key="${index}" style="${style}">${word}</span>`;
        }
    }).join('');
    let tag = document.getElementById('button-title');
    tag.innerHTML = textMap;
    
}

buttonTextAnimation();
textAnimation();
AOS.init();

let page_map = ["home", "misiune", "about", "echipa", "blog", "formular"];

let indexPage = 0;

var element = document.getElementById(page_map[indexPage]);
element.scrollIntoView({behavior: 'smooth'}, true);

document.body.addEventListener('keydown', function(event) {
    if (event.key === 'ArrowDown') {
        event.preventDefault();

        if ((indexPage + 1) > page_map.length - 1) return;
        indexPage++;
        
        let element = document.getElementById(page_map[indexPage]);
        element.scrollIntoView({behavior: 'smooth'}, true);
    }

    else if (event.key == 'ArrowUp') {
        event.preventDefault();

        if ((indexPage - 1) < 0) return;
        indexPage--;
        
        let element = document.getElementById(page_map[indexPage]);
        element.scrollIntoView({behavior: 'smooth'}, true);

    } else return;
});