<?php
	class DbFormular extends DbBase
	{ 

		/**
		 * @var int Id
		 */
		public $Id; 

		/**
		 * @var string Nume
		 */
		public $Nume; 

		/**
		 * @var string Prenume
		 */
		public $Prenume; 

		/**
		 * @var int Telefon
		 */
		public $Telefon; 

		/**
		 * @var string Email
		 */
		public $Email; 

		/**
		 * @var string Localitate
		 */
		public $Localitate; 

		/**
		 * @var string Mesaj
		 */
		public $Mesaj; 

		/**
		 * @var \DateTime DataCreare
		 */
		public $DataCreare; 

		/**
		 * @var string Status
		 */
		public $Status; 

		/**
		 * @return String numele tabelului din db
		 */
		public static function _getTableName()
		{
			return 'formular';
		}
		
		/**
		 * @return string[] intoarce lista de coloane
		 */
		public function _getColumns()
		{
			return array('Id','Nume','Prenume','Telefon','Email','Localitate','Mesaj','DataCreare','Status');
		}
		

		/* @return DbFormularModel OR null */
		public static function QueryRow()
		{
			return parent::QueryRow();
		}

		/* @return DbFormularModel[] */
		public static function QueryResult()
		{
			return parent::QueryResult();
		}

		/* @return DbFormularModel[] */
		public static function QuerySql($sql)
		{
			return parent::QuerySql( $sql);
		}

		public static function query()
		{
			return new DbFormular_Queryable( static::_getTableName() );
		}

		
		public static function constructModel( $id=null)
		{
			return new DbFormular( $id);
		}
	}
	class DbFormular_Queryable extends DbQueryableBase
	{
		/* @return DbFormularModel[] */
		public function get()
		{
			return DbFormularModel::QueryResult();
		}

		/* @return DbFormularModel[] */
		public function get_row()
		{
			return DbFormularModel::QueryRow();
		}
	}
		