<?php
	class DbEchipa extends DbBase
	{ 

		/**
		 * @var int Id
		 */
		public $Id; 

		/**
		 * @var string Nume
		 */
		public $Nume; 

		/**
		 * @var string Prenume
		 */
		public $Prenume; 

		/**
		 * @var string Imagine
		 */
		public $Imagine; 

		/**
		 * @var int NrOrdine
		 */
		public $NrOrdine; 

		/**
		 * @return String numele tabelului din db
		 */
		public static function _getTableName()
		{
			return 'echipa';
		}
		
		/**
		 * @return string[] intoarce lista de coloane
		 */
		public function _getColumns()
		{
			return array('Id','Nume','Prenume','Imagine','NrOrdine');
		}
		

		/* @return DbEchipaModel OR null */
		public static function QueryRow()
		{
			return parent::QueryRow();
		}

		/* @return DbEchipaModel[] */
		public static function QueryResult()
		{
			return parent::QueryResult();
		}

		/* @return DbEchipaModel[] */
		public static function QuerySql($sql)
		{
			return parent::QuerySql( $sql);
		}

		public static function query()
		{
			return new DbEchipa_Queryable( static::_getTableName() );
		}

		
		public static function constructModel( $id=null)
		{
			return new DbEchipa( $id);
		}
	}
	class DbEchipa_Queryable extends DbQueryableBase
	{
		/* @return DbEchipaModel[] */
		public function get()
		{
			return DbEchipaModel::QueryResult();
		}

		/* @return DbEchipaModel[] */
		public function get_row()
		{
			return DbEchipaModel::QueryRow();
		}
	}
		