<?php
	class DbBlog extends DbBase
	{ 

		/**
		 * @var int Id
		 */
		public $Id; 

		/**
		 * @var string Titlu
		 */
		public $Titlu; 

		/**
		 * @var string Slug
		 */
		public $Slug; 

		/**
		 * @var string MetaDescriere
		 */
		public $MetaDescriere; 

		/**
		 * @var string Descriere
		 */
		public $Descriere; 

		/**
		 * @var string Content
		 */
		public $Content; 

		/**
		 * @var string Imagine
		 */
		public $Imagine; 

		/**
		 * @var \DateTime DataCreare
		 */
		public $DataCreare; 

		/**
		 * @return String numele tabelului din db
		 */
		public static function _getTableName()
		{
			return 'blog';
		}
		
		/**
		 * @return string[] intoarce lista de coloane
		 */
		public function _getColumns()
		{
			return array('Id','Titlu','Slug','MetaDescriere','Descriere','Content','Imagine','DataCreare');
		}
		

		/* @return DbBlogModel OR null */
		public static function QueryRow()
		{
			return parent::QueryRow();
		}

		/* @return DbBlogModel[] */
		public static function QueryResult()
		{
			return parent::QueryResult();
		}

		/* @return DbBlogModel[] */
		public static function QuerySql($sql)
		{
			return parent::QuerySql( $sql);
		}

		public static function query()
		{
			return new DbBlog_Queryable( static::_getTableName() );
		}

		
		public static function constructModel( $id=null)
		{
			return new DbBlog( $id);
		}
	}
	class DbBlog_Queryable extends DbQueryableBase
	{
		/* @return DbBlogModel[] */
		public function get()
		{
			return DbBlogModel::QueryResult();
		}

		/* @return DbBlogModel[] */
		public function get_row()
		{
			return DbBlogModel::QueryRow();
		}
	}
		