<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	public function index()
	{
       $ret = new stdClass();
		$data = [];

		$seo = [];
		$seo['Seo'] = $this->getSeoData(-1);

		$queryLast2Blog = "SELECT * FROM blog ORDER BY Id DESC LIMIT 2";
		$blog = $this->db->query($queryLast2Blog)->result();

		$query = "SELECT * FROM echipa e WHERE 1 = 1 ORDER BY e.Id ";
		$echipa = $this->db->query($query)->result();

		$data['Echipa'] 	= $echipa;
		$data['Blog'] 		= $blog;

	   $this->load->view('components/header', $seo);
	   $this->load->view('pages/home', $data);
	   $this->load->view('components/footer');
	}

	public function blog($index = 1) {
		// echo $index;
		$limit = 4;
		$offset = ($index - 1) * $limit;
		$pagesQuery = "SELECT COUNT(*) as NumarTotal FROM blog WHERE 1 = 1";
		$NumarTotalPagini = $this->db->query($pagesQuery)->result()[0]->NumarTotal;

		if ($NumarTotalPagini == null) $NumarTotalPagini = 1;
		else $NumarTotalPagini = ceil($NumarTotalPagini/4);

		$data = [];

		$seo = [];
		$seo['Seo'] = $this->getSeoData(-2);

		$query = "SELECT * FROM blog ORDER BY Id DESC LIMIT $limit OFFSET $offset";
		$blogs = $this->db->query($query)->result();

		$data['Blogs'	] 		= $blogs;
		$data['Page'	]		= $index;
		$data['Pages'	]		= $NumarTotalPagini;

		// echo json_encode($data);
		$this->load->view('components/header', $seo);
		$this->load->view('components/navbar');
		$this->load->view('pages/blog/blog', $data);
		$this->load->view('components/footer');


	} 

	public function getBlog($Id) {
		$ret = new stdClass();

		$seo = [];
		$data = [];

	}


	private function getSeoData($Id) {
		$ret = new stdClass();
		

		if ($Id == -1) {
			$ret->Title = 'Despre bani';
			$ret->Description = 'Educație financiară personală, pentru toți românii, oriunde.';
			$ret->Url = base_url();
			$ret->Image = base_url('assets/images/static/logo/logo_alb.png');

		} else if ($Id == -2) {
			$ret->Title = 'Blog';
			$ret->Description = 'Educație financiară personală, pentru toți românii, oriunde.';
			$ret->Url = base_url('blog-list');
			$ret->Image = base_url('assets/images/static/logo/logo_alb.png');

		} else {
			$blog = new DbBlogModel($Id);
			$ret->Description = $blog->MetaDescriere;
			$ret->Image = base_url('assets/images/blog/'.$blog->Imagine);
			$ret->Url = base_url('blog-page/'.$blog->Slug);
		}
		
		return $ret;
	}
	
}
